'use strict';

/* --------------------------------------------------------------
 events.js 2016-02-25
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

jse.libs.theme.events = jse.libs.theme.events || {};

/**
 * ## Honeygrid Event Constants Library
 *
 * Contains all triggered custom event names. Use the methods to get the event names.
 *
 * @module Honeygrid/Libs/events
 * @exports jse.libs.theme.events
 */
(function (exports) {

  'use strict';

  /**
   * OPEN_FLYOUT Constant
   *
   * @return {string}
   */

  exports.OPEN_FLYOUT = function () {
    return 'OPEN_FLYOUT';
  };

  /**
   * TRANSITION Constant
   *
   * @return {string}
   */
  exports.TRANSITION = function () {
    return 'TRANSITION';
  };

  /**
   * TRANSITION_FINISHED Constant
   *
   * @return {string}
   */
  exports.TRANSITION_FINISHED = function () {
    return 'TRANSITION_FINISHED';
  };

  /**
   * TRANSITION_STOP Constant
   *
   * @return {string}
   */
  exports.TRANSITION_STOP = function () {
    return 'TRANSITION_STOP';
  };

  /**
   * BREAKPOINT Constant
   *
   * @return {string}
   */
  exports.BREAKPOINT = function () {
    return 'BREAKPOINT';
  };

  /**
   * CART_OPEN Constant
   *
   * @return {string}
   */
  exports.CART_OPEN = function () {
    return 'CART_DROPDOWN_OPEN';
  };

  /**
   * CART_CLOSE Constant
   *
   * @return {string}
   */
  exports.CART_CLOSE = function () {
    return 'CART_DROPDOWN_CLOSE';
  };

  /**
   * CART_UPDATE Constant
   *
   * @return {string}
   */
  exports.CART_UPDATE = function () {
    return 'CART_DROPDOWN_UPDATE';
  };

  /**
   * SWIPER_GOTO Constant
   *
   * @return {string}
   */
  exports.SWIPER_GOTO = function () {
    return 'SWIPER_GOTO';
  };

  /**
   * SLIDES_UPDATE Constant
   *
   * @return {string}
   */
  exports.SLIDES_UPDATE = function () {
    return 'SLIDES_UPDATE';
  };

  /**
   * CHECK_CART Constant
   *
   * @return {string}
   */
  exports.CHECK_CART = function () {
    return 'CHECK_CART';
  };

  /**
   * CART_UPDATED Constant
   *
   * @return {string}
   */
  exports.CART_UPDATED = function () {
    return 'CART_UPDATED';
  };

  /**
   * REPOSITIONS_STICKYBOX Constant
   *
   * @return {string}
   */
  exports.REPOSITIONS_STICKYBOX = function () {
    return 'REPOSITIONS_STICKYBOX';
  };

  /**
   * ADD_CUSTOMIZER_WISHLIST Constant
   *
   * @return {string}
   */
  exports.ADD_CUSTOMIZER_WISHLIST = function () {
    return 'ADD_CUSTOMIZER_WISHLIST';
  };

  /**
   * ADD_CUSTOMIZER_CART Constant
   *
   * @return {string}
   */
  exports.ADD_CUSTOMIZER_CART = function () {
    return 'ADD_CUSTOMIZER_CART';
  };

  /**
   * WISHLIST_TO_CART Constant
   *
   * @return {string}
   */
  exports.WISHLIST_TO_CART = function () {
    return 'WISHLIST_TO_CART';
  };

  /**
   * WISHLIST_CART_DELETE Constant
   *
   * @return {string}
   */
  exports.WISHLIST_CART_DELETE = function () {
    return 'WISHLIST_CART_DELETE';
  };

  /**
   * MENU_REPOSITIONED Constant
   *
   * @return {string}
   */
  exports.MENU_REPOSITIONED = function () {
    return 'MENU_REPOSITIONED';
  };

  /**
   * STICKYBOX_CONTENT_CHANGE Constant
   *
   * @returns {string}
   */
  exports.STICKYBOX_CONTENT_CHANGE = function () {
    return 'STICKYBOX_CONTENT_CHANGE';
  };

  /**
   * SHARE_CART_MODAL_READY Constant
   *
   * @returns {string}
   */
  exports.SHARE_CART_MODAL_READY = function () {
    return 'SHARE_CART_MODAL_READY';
  };

  /**
   * SLIDER_RESPONSIVE_READY Constant
   *
   * @returns {string}
   */
  exports.SLIDER_RESPONSIVE_READY = function () {
    return 'SLIDER_RESPONSIVE_READY';
  };
})(jse.libs.theme.events);

jse.libs.template = jse.libs.template || {};
jse.libs.template.event = jse.libs.theme.event;
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
